<?php 
   /**
    *
    * copyright (c) 2013-2023 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/index.php?alias=linee-guida-per-luso-del-logo-geecom
    */

    include "../include/includeBaseComponenti.php";
    include "../../../template/stile.php";
    include "classi/VisualizzatoreGalleria.php";
    
    if(isset($_GET["id"])) {
        $visualizzatoreGalleria = new VisualizzatoreGalleria($geecomDb, filter_input(INPUT_GET, "id",FILTER_SANITIZE_NUMBER_INT));
        $visualizzatoreGalleria->caricaDatiDalDatabase();
    }
    
    if(isset($_GET["status"])) {
        $status = filter_input(INPUT_GET,"status",FILTER_SANITIZE_NUMBER_INT);
    }
    else {
        $status = 0;
    }
?>
<!doctype html>
<html lang="en">
    <head>
        <!-- Required meta tags -->
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">

        <?php
            include "../include/cssBaseComponenti.php";
        ?>
        <title>Geecom CMS - Creazione Griglia contenuti</title>
    </head>
    <body>
    
        <header>
            <?php 
                include "../../include/barraSuperiore.php";

                include "../../include/header.php";

                include "../../include/barraMenu.php";
            ?>
        </header>

        <main role="main" class="bg-light" id="main">
            <div class="container-fluid">
                <div class="row py-4">
                    <?php 
                        if($status==200) {
                            echo"<div class=\"col-12\">
                                    <div class=\"alert alert-success alert-dismissible fade show\" role=\"alert\">
                                        Visualizzatore creato
                                        <button type=\"button\" class=\"close\" data-dismiss=\"alert\" aria-label=\"Close\">
                                              <span aria-hidden=\"true\">&times;</span>
                                        </button>
                                    </div>
                                </div>";
                        }
                        
                        if($status==250) {
                            echo"<div class=\"col-12\">
                                    <div class=\"alert alert-success alert-dismissible fade show\" role=\"alert\">
                                        Visualizzatore modificato
                                        <button type=\"button\" class=\"close\" data-dismiss=\"alert\" aria-label=\"Close\">
                                              <span aria-hidden=\"true\">&times;</span>
                                        </button>
                                    </div>
                                </div>";
                        }
                    ?>
                    <div class="col-12">
                        <div class="form-row justify-content-between mb-3">
                            <div class="col-auto d-flex">
                                <nav aria-label="breadcrumb" class="align-self-center">
                                    <ol class="breadcrumb p-0 mb-1 mb-md-0 bg-transparent">
                                        <li class="breadcrumb-item"><a href="../../home.php">Home</a></li>
                                        <li class="breadcrumb-item"><a href="#" data-toggle="modal" data-target="#menu-componenti">Componenti</a></li>
                                        <li class="breadcrumb-item"><a href="index.php">Visualizzatore galleria</a></li>
                                        <li class="breadcrumb-item active" aria-current="page"><?php echo((isset($visualizzatoreGalleria)? $visualizzatoreGalleria->getNome() : "Nuovo visualizzatore galleria"))?></li>
                                    </ol>
                                </nav>
                            </div>
                            <div class="col-auto text-right">
                                <a class="btn btn-outline-primary" href="index.php"><i class="fas fa-arrow-left mr-2"></i>Torna all'elenco</a>
                                <button class="btn btn-primary" onclick="document.formComponente.submit()"><i class="fas fa-check"></i> Salva</button>
                                <?php 
                                    if(isset($video)) {
                                ?>
                                    <button type="button" class="btn btn-warning mt-2 mt-lg-0" onclick="location.href='controller/controllerVideo.php?id=<?php echo $video["id"] ?>&operazione=duplica';"><i class="far fa-clone mr-2"></i>Duplica</button>
                                <?php
                                    }
                                ?>
                            </div>
                        </div>
                        <div class="card mb-4 box-shadow-lite">
                            <form name="formComponente" action="controller/controllerComponente.php" method="post">
                                <input type="text" class="d-none" name="operazione" value="<?php echo((isset($visualizzatoreGalleria) ? "modifica" : "crea")); ?>">
                                <input type="text" class="d-none" name="id" value="<?php echo((isset($visualizzatoreGalleria) ? $visualizzatoreGalleria->getId() : "0")); ?>">
                                
                                <div class="card-body">
                                    <div class="row">
                                        <div class="col-md-6">
                                            <label>Nome</label>
                                            <input type="text" class="form-control" id="nomeSlider" name="nome" aria-describedby="nome griglia" value="<?php echo((isset($visualizzatoreGalleria) ? $visualizzatoreGalleria->getNome() : "")) ?>" placeholder="Nome occorrenza">
                                        </div>
                                        <div class="col-md-6 form-group">
                                            <label>Galleria</label>
                                            <select id="idGalleria" name="idGalleria" class="selectpicker" data-live-search="true" data-width="100%" data-size="5">
                                                <option value="0">Seleziona</option>
                                                <?php
                                                    $queryNomiTag = "SELECT * FROM geecB_contenuti WHERE tipo LIKE 'galleria'";
                                                    $risNomi = $geecomDb->eseguiQueryLettura($queryNomiTag);
                                                    while($contenuto = $risNomi->fetch_assoc()) {
                                                        if($visualizzatoreGalleria->getIdGalleria()==$contenuto["id"]) {
                                                            echo"<option value=\"{$contenuto["id"]}\" selected>{$contenuto["titolo"]}</option>";						
                                                        }
                                                        else {
                                                            echo"<option value=\"{$contenuto["id"]}\">{$contenuto["titolo"]}</option>";
                                                        }
                                                    }
                                                ?>
                                            </select>
                                            <small class="text-muted">Seleziona la galleria da mostrare</small>
                                        </div>
                                        
                                        <div class="col-md-6 col-xl-2 form-group">
                                            <label for="inputPassword3" >Spazio occupato</label>
                                            <select class="form-control" name="spazioOccupato">
                                            <?php 
                                                foreach($arrayDimensioniColonna as $classe=>$descrizione) {
                                                    if(isset($visualizzatoreGalleria) && $visualizzatoreGalleria->getSpazioOccupato()==$classe) {
                                                        echo"<option value=\"$classe\" selected>$descrizione</option>";
                                                    }
                                                    else {
                                                        echo"<option value=\"$classe\">$descrizione</option>";
                                                    }
                                                }
                                            ?>
                                            </select>
                                            <small class="text-muted">Lo spazio orizzontale occupato dal componente</small>
                                        </div>
                                        
                                        <div class="col-md-6 col-xl-2 form-group">
                                            <label class="d-block">Aspetto</label>
                                            <select class="form-control" name="tipoVisualizzazione">
                                                <?php
                                                    $arrayClassiElemento = array("miniature"=>"Miniature","slider"=>"Slider");
                                                    foreach($arrayClassiElemento as $classe=>$numeroELementi) {
                                                        if(isset($visualizzatoreGalleria) && $classe==$visualizzatoreGalleria->getAspetto()) {
                                                            echo"<option value=\"$classe\" SELECTED>{$numeroELementi}</option>";						
                                                        }
                                                        else {
                                                            echo"<option value=\"$classe\">{$numeroELementi}</option>";
                                                        }
                                                    }
                                                ?>
                                            </select>
                                        </div>
                                        
                                        <div class="col-md-6 col-xl-2 form-group">
                                            <label class="d-block">Aspect ratio</label>
                                            <select class="form-control" name="aspectRatio">
                                                <?php 
                                                    $arrayAspectRatio = array(""=>"Proporzioni libere","aspect-ratio-1-1"=>"1:1","aspect-ratio-4-3"=>"4:3","aspect-ratio-16-9"=>"16:9","aspect-ratio-3-4"=>"3:4","aspect-ratio-3-2"=>"3:2","aspect-ratio-8-5"=>"8:5","aspect-ratio-9-16"=>"9:16");
                                                    foreach($arrayAspectRatio as $classe=>$opzione) {
                                                        if(isset($visualizzatoreGalleria) && $classe==$visualizzatoreGalleria->getAspectRatio() ) {
                                                            echo"<option value=\"$classe\" SELECTED>{$opzione}</option>";						
                                                        }
                                                        else {
                                                            echo"<option value=\"$classe\">{$opzione}</option>";
                                                        }
                                                    }
                                                ?>
                                            </select>
                                        </div>
                                    </div>
                                </div>
                            </form>
                            <div class="card-footer">
                                <button type="button" class="btn btn-primary float-right" onclick="inviaDati()"><i class="fas fa-check"></i> Salva</button>
                            </div>
                        </div>

                    </div>
                </div>
            </div>
        </main>

        <?php
            include "../../include/footer.php";

            include "../include/modal/cambiaPassword.php";
            
            include "../include/modal/eliminaElemento.php";

            include "../../include/modal/modalMenuComponenti.php";

            include "../../include/modal/operazioneCompletata.php";

            include "../include/jsBaseComponenti.php";
        ?>

        <script>
            function eliminaElemento(id,nomeElemento,tipoElemento) {
                $('#elementoDaEliminare').val(id);
                $('#nomeElementoDaEliminare').text(nomeElemento);
                $('#modalEliminaElemento').modal('show');
            }
            
            function eseguiEliminazioneElemento() {
                var id = $('#elementoDaEliminare').val();
                $.ajax({
                    type:"POST",
                    url:"controller/controllerComponente.php",
                    data:{
                        operazione:"eliminaElemento",
                        id:<?php echo $visualizzatoreGalleria->getId() ?>,
                        idElemento:id
                    },
                    success:function(esito) {
                        if(esito=="ok") {
                            document.getElementById("elementoComponente"+id).className = "d-none";
                            $('#modalEliminaElemento').modal('hide');
                        }
                    },
                    error: function() {
                        alert("Si sono verificato problemi durante la richiesta, riprova tra qualche istante");
                    }
                });
            }
            
            function spostaElementoInput(id) {
                var posizione = $('#nuovaPosizioneElemento'+id).val();
                spostaElemento(id,posizione);
            }
            
            function spostaElemento(id,posizione) {
                $.ajax({
                    type:"POST",
                    url:"controller/controllerComponente.php",
                    data:{
                        operazione:"spostaElemento",
                        id:<?php echo $visualizzatoreGalleria->getId() ?>,
                        idElemento:id,
                        posizione:posizione
                    },
                    success:function(esito) {
                        if(esito=="ok") {
                            aggiornaDivElementi();
                        }
                        else {
                            alert(esito);
                        }
                    },
                    error: function() {
                        alert("Si sono verificato problemi durante la richiesta, riprova tra qualche istante");
                    }
                });
            }
            
            function creaElemento() {
                var nome  = $('#nomeElemento').val();
                var ruolo = $('#ruoloElemento').val();
                var descrizione = $('#descrizioneElemento').val();
                
                $.ajax({
                    type:"POST",
                    url:"controller/controllerComponente.php",
                    data:{
                        operazione:"creaElemento",
                        id:<?php echo $visualizzatoreGalleria->getId() ?>,
                        nome:nome,
                        ruolo:ruolo,
                        descrizione:descrizione
                    },
                    success:function(esito) {
                        alert(esito);
                        if(esito=="ok") {
                            aggiornaDivElementi();
                        }
                        else {
                            alert("Si è verificato un errore, contatta l'amministratore del sito")
                        }
                    },
                    error: function() {
                        alert("Si sono verificato problemi durante la richiesta, riprova tra qualche istante");
                    }
                });
            }
            
            function aggiornaDivElementi() {
                $.ajax({
                    type:"POST",
                    url:"controller/controllerComponente.php",
                    data:{
                        operazione:"stampaElementi",
                        id:<?php echo $visualizzatoreGalleria->getId() ?>
                    },
                    success:function(result) {
                        document.getElementById("divElencoElementi").innerHTML = result;
                        $('#modifica-voce-menu').modal('hide');
                    },
                    error: function() {
                        alert("Si sono verificato problemi durante la richiesta, riprova tra qualche istante");
                    }
                });
            }
            
            function inviaDati() {
                if(document.getElementById("idGalleria").value=="") {
                    alert("Seleziona una galleria");
                }
                else {
                    document.formComponente.submit();
                }
            }
        </script>
    </body>
</html>